

<?php $__env->startSection('title', 'Users Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-container">
    <div class="dashboard-header">
        <div class="d-flex justify-content-between align-items-center">
            <h1>Users Management</h1>
            
            
        </div>
        <p>Manage your community members</p>
    </div>

    <div class="dashboard-card">
        <div class="dashboard-card-header">
            <h3>Users</h3>
        </div>
        <div class="dashboard-card-body">
            <div class="users-filters mb-3">
                <form action="<?php echo e(route('admin.users.index')); ?>" method="GET" class="w-100">
                    <div class="d-flex gap-3 flex-wrap align-items-end">
                        <div class="filter-group flex-grow-1">
                            <label for="search">Search</label>
                            <input 
                                type="text" 
                                id="search" 
                                name="search" 
                                value="<?php echo e(request('search')); ?>" 
                                placeholder="Search by name or Steam ID" 
                                class="form-control"
                            >
                        </div>
                        <div class="filter-group">
                            <label for="role">Role</label>
                            <select id="role" name="role" class="form-select">
                                <option value="">All Roles</option>
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($role); ?>" <?php echo e(request('role') == $role ? 'selected' : ''); ?>>
                                        <?php echo e(ucfirst($role)); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="filter-actions d-flex gap-2">
                            <button type="submit" class="btn btn-primary">Filter</button>
                            <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-secondary">Reset</a>
                        </div>
                    </div>
                </form>
            </div>

            <div class="table-responsive">
                <table class="table users-table align-middle">
                    <thead>
                        <tr>
                            <th>Avatar</th>
                            <th>Name</th>
                            <th>Steam ID</th>
                            <th>Roles</th>
                            <th>Last Active</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <img src="<?php echo e($user->avatar); ?>" alt="<?php echo e($user->name); ?>" class="avatar-sm rounded-circle">
                                </td>
                                <td><?php echo e($user->name); ?></td>
                                <td>
                                    <?php if($user->steamid): ?>
                                    <a href="<?php echo e($user->getSteamProfileUrl()); ?>" target="_blank" class="steam-link">
                                        <?php echo e($user->steamid); ?>

                                        <i class="fas fa-external-link-alt ms-1"></i>
                                    </a>
                                    <?php else: ?>
                                        —
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php $__empty_2 = true; $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                        <span class="user-role 
                                            <?php echo e(strtolower($role->name) == 'admin' ? 'role-admin' : (strtolower($role->name) == 'moderator' ? 'role-moderator' : 'role-user')); ?>">
                                            <?php echo e($role->name); ?>

                                        </span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                        <span class="user-role role-user">User</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($user->last_active_at ? $user->last_active_at->diffForHumans() : 'Never'); ?></td>
                                <td>
                                    <div class="user-actions d-flex gap-2">
                                        <a href="<?php echo e(route('admin.users.show', $user)); ?>" class="btn-icon btn-info" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.users.edit', $user)); ?>" class="btn-icon btn-success" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <?php if(auth()->id() !== $user->id): ?>
                                            <form action="<?php echo e(route('admin.users.destroy', $user)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this user?');">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn-icon btn-danger" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center">No users found</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <div class="pagination mt-3">
                <?php echo e($users->appends(request()->query())->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/admin/users/index.blade.php ENDPATH**/ ?>